 IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_NF_ENT_DANFE_PROVISORIO_ERROS_VALIDACAO_PRODUTO_NASCIMENTO]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_EST_NF_ENT_DANFE_PROVISORIO_ERROS_VALIDACAO_PRODUTO_NASCIMENTO]
GO
  
CREATE PROCEDURE P_EST_NF_ENT_DANFE_PROVISORIO_ERROS_VALIDACAO_PRODUTO_NASCIMENTO AS

SET NOCOUNT ON;
BEGIN TRY 
IF  OBJECT_ID('TEMPDB.DBO.#TMP_CD_CTR_ERROS') IS NOT NULL
BEGIN
	DROP TABLE #TMP_CD_CTR_ERROS
END

SELECT 
	CD_CTR_ERROS
	INTO #TMP_CD_CTR_ERROS
FROM 
	V_EST_NF_ENT_DANFE_PROVISORIO d
	INNER JOIN EST_NF_ENT_DANFE_PROVISORIO_ERROS_VALIDACAO e ON 
	d.CD_CTR = e.CD_CTR  
	LEFT OUTER JOIN EST_PROD_CPL_NASC ON 
	d.CD_EMP = EST_PROD_CPL_NASC.CD_EMP AND 
	d.CD_FILIAL = EST_PROD_CPL_NASC.CD_FILIAL AND 
	d.CD_PROD = EST_PROD_CPL_NASC.CD_PROD
WHERE
	 EST_PROD_CPL_NASC.CD_PROD IS NULL;

INSERT INTO EST_PROD_CPL_NASC(CD_EMP,CD_FILIAL,CD_PROD,DT_NASC,MEDIA_F_LIBERADA,QTDE_MES_VENDA_FECHADO)
SELECT   
    DISTINCT 
	d.CD_EMP,
	d.CD_FILIAL,
	d.CD_PROD,
	CONVERT(CHAR(10),GETDATE(),112),
	0,
	0
FROM            
	V_EST_NF_ENT_DANFE_PROVISORIO d
	INNER JOIN EST_NF_ENT_DANFE_PROVISORIO_ERROS_VALIDACAO e ON 
	d.CD_CTR = e.CD_CTR  
	LEFT OUTER JOIN EST_PROD_CPL_NASC ON 
	d.CD_EMP = EST_PROD_CPL_NASC.CD_EMP AND 
	d.CD_FILIAL = EST_PROD_CPL_NASC.CD_FILIAL AND 
	d.CD_PROD = EST_PROD_CPL_NASC.CD_PROD
	JOIN EST_PROD_CPL C ON 
	d.CD_EMP = c.CD_EMP AND 
	d.CD_FILIAL = c.CD_FILIAL AND 
	d.CD_PROD = c.CD_PROD
WHERE
	 EST_PROD_CPL_NASC.CD_PROD IS NULL;

DELETE FROM B
FROM
	#TMP_CD_CTR_ERROS A 
	INNER JOIN EST_NF_ENT_DANFE_PROVISORIO_ERROS_VALIDACAO B ON 
	A.CD_CTR_ERROS = B.CD_CTR_ERROS; 

DROP TABLE #TMP_CD_CTR_ERROS
END TRY 
BEGIN CATCH
    INSERT INTO ADM_ERRO
		(numero
	   , severidade
	   , estado
	   , rotina
	   , linha
	   , mensagem
	   , dtErro
		)
			   SELECT ERROR_NUMBER() AS numero
					, ERROR_SEVERITY() AS severidade
					, ERROR_STATE() AS estado
					, 'Rotina P_EST_NF_ENT_DANFE_PROVISORIO_ERROS_VALIDACAO_PRODUTO_NASCIMENTO ' AS rotina
					, ERROR_LINE() AS linha
					, ERROR_MESSAGE() AS mensagem
					, GETDATE() AS dtErro; 
END CATCH